/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queryparser.flexible.core.nodes;

import java.util.List;
import org.apache.lucene.ars_nouveau.queryparser.flexible.core.nodes.AndQueryNode;
import org.apache.lucene.ars_nouveau.queryparser.flexible.core.nodes.FieldQueryNode;
import org.apache.lucene.ars_nouveau.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.ars_nouveau.queryparser.flexible.core.parser.EscapeQuerySyntax;

public class AnyQueryNode
extends AndQueryNode {
    private CharSequence field;
    private int minimumMatchingElements;

    public AnyQueryNode(List<QueryNode> clauses, CharSequence field, int minimumMatchingElements) {
        super(clauses);
        this.field = field;
        this.minimumMatchingElements = minimumMatchingElements;
        if (clauses != null) {
            for (QueryNode clause : clauses) {
                if (!(clause instanceof FieldQueryNode)) continue;
                ((FieldQueryNode)clause).toQueryStringIgnoreFields = true;
                ((FieldQueryNode)clause).setField(field);
            }
        }
    }

    public int getMinimumMatchingElements() {
        return this.minimumMatchingElements;
    }

    public CharSequence getField() {
        return this.field;
    }

    public String getFieldAsString() {
        if (this.field == null) {
            return null;
        }
        return this.field.toString();
    }

    public void setField(CharSequence field) {
        this.field = field;
    }

    @Override
    public QueryNode cloneTree() throws CloneNotSupportedException {
        AnyQueryNode clone = (AnyQueryNode)super.cloneTree();
        clone.field = this.field;
        clone.minimumMatchingElements = this.minimumMatchingElements;
        return clone;
    }

    @Override
    public String toString() {
        if (this.getChildren() == null || this.getChildren().isEmpty()) {
            return "<any field='" + String.valueOf(this.field) + "'  matchelements=" + this.minimumMatchingElements + "/>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<any field='").append(this.field).append("'  matchelements=").append(this.minimumMatchingElements).append('>');
        for (QueryNode clause : this.getChildren()) {
            sb.append("\n");
            sb.append(clause.toString());
        }
        sb.append("\n</any>");
        return sb.toString();
    }

    @Override
    public CharSequence toQueryString(EscapeQuerySyntax escapeSyntaxParser) {
        String anySTR = "ANY " + this.minimumMatchingElements;
        StringBuilder sb = new StringBuilder();
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            String filler = "";
            for (QueryNode clause : this.getChildren()) {
                sb.append(filler).append(clause.toQueryString(escapeSyntaxParser));
                filler = " ";
            }
        }
        if (this.isDefaultField(this.field)) {
            return "( " + String.valueOf(sb) + " ) " + anySTR;
        }
        return String.valueOf(this.field) + ":(( " + String.valueOf(sb) + " ) " + anySTR + ")";
    }
}

